/* THIS FILE IS AUTOGENERATED FROM AnimationEffect.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_AnimationEffectBinding_h
#define mozilla_dom_AnimationEffectBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class AnimationEffect;
struct AnimationEffectAtoms;
struct ComputedEffectTimingAtoms;
struct EffectTimingAtoms;
struct NativePropertyHooks;
struct OptionalEffectTimingAtoms;
class OwningUnrestrictedDoubleOrString;
class ProtoAndIfaceCache;
class UnrestrictedDoubleOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class FillMode : uint8_t {
  None,
  Forwards,
  Backwards,
  Both,
  Auto,
  EndGuard_
};

namespace FillModeValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(FillMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(FillMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace FillModeValues

bool
ToJSValue(JSContext* aCx, FillMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PlaybackDirection : uint8_t {
  Normal,
  Reverse,
  Alternate,
  Alternate_reverse,
  EndGuard_
};

namespace PlaybackDirectionValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PlaybackDirection::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(PlaybackDirection stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace PlaybackDirectionValues

bool
ToJSValue(JSContext* aCx, PlaybackDirection aArgument, JS::MutableHandle<JS::Value> aValue);


class UnrestrictedDoubleOrString
{
  friend class UnrestrictedDoubleOrStringArgument;
  enum Type
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };

  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  Type mType;
  Value mValue;

  UnrestrictedDoubleOrString(const UnrestrictedDoubleOrString&) = delete;
  UnrestrictedDoubleOrString& operator=(const UnrestrictedDoubleOrString&) = delete;
public:
  explicit inline UnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedDoubleOrString()
  {
    Uninit();
  }

  inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnrestrictedDoubleOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUnrestrictedDoubleOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };

  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningUnrestrictedDoubleOrString(const OwningUnrestrictedDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  double&
  RawSetAsUnrestrictedDouble();

  double&
  SetAsUnrestrictedDouble();

  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningUnrestrictedDoubleOrString&
  operator=(const OwningUnrestrictedDoubleOrString& aOther);

private:
  void
  DestroyUnrestrictedDouble();

  void
  DestroyString();
};


struct EffectTiming : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mDelay;
  MOZ_INIT_OUTSIDE_CTOR PlaybackDirection mDirection;
  MOZ_INIT_OUTSIDE_CTOR OwningUnrestrictedDoubleOrString mDuration;
  MOZ_INIT_OUTSIDE_CTOR nsString mEasing;
  MOZ_INIT_OUTSIDE_CTOR double mEndDelay;
  MOZ_INIT_OUTSIDE_CTOR FillMode mFill;
  MOZ_INIT_OUTSIDE_CTOR double mIterationStart;
  MOZ_INIT_OUTSIDE_CTOR double mIterations;

  EffectTiming();

  explicit inline EffectTiming(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline EffectTiming(const EffectTiming& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  EffectTiming&
  operator=(const EffectTiming& aOther);

private:
  static bool
  InitIds(JSContext* cx, EffectTimingAtoms* atomsCache);
};

namespace binding_detail {
struct FastEffectTiming : public EffectTiming
{
  inline FastEffectTiming()
    : EffectTiming(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct OptionalEffectTiming : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<PlaybackDirection> mDirection;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUnrestrictedDoubleOrString> mDuration;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mEasing;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mEndDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<FillMode> mFill;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mIterationStart;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mIterations;

  OptionalEffectTiming();

  explicit inline OptionalEffectTiming(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline OptionalEffectTiming(const OptionalEffectTiming& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  OptionalEffectTiming&
  operator=(const OptionalEffectTiming& aOther);

private:
  static bool
  InitIds(JSContext* cx, OptionalEffectTimingAtoms* atomsCache);
};

namespace binding_detail {
struct FastOptionalEffectTiming : public OptionalEffectTiming
{
  inline FastOptionalEffectTiming()
    : OptionalEffectTiming(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ComputedEffectTiming : public EffectTiming
{
  MOZ_INIT_OUTSIDE_CTOR double mActiveDuration;
  MOZ_INIT_OUTSIDE_CTOR Nullable<double> mCurrentIteration;
  MOZ_INIT_OUTSIDE_CTOR double mEndTime;
  MOZ_INIT_OUTSIDE_CTOR Nullable<double> mLocalTime;
  MOZ_INIT_OUTSIDE_CTOR Nullable<double> mProgress;

  ComputedEffectTiming();

  explicit inline ComputedEffectTiming(const FastDictionaryInitializer& )
    : EffectTiming(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ComputedEffectTiming(const ComputedEffectTiming& aOther)
    : EffectTiming(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ComputedEffectTiming&
  operator=(const ComputedEffectTiming& aOther);

  bool
  operator==(const ComputedEffectTiming& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ComputedEffectTimingAtoms* atomsCache);
};

namespace binding_detail {
struct FastComputedEffectTiming : public ComputedEffectTiming
{
  inline FastComputedEffectTiming()
    : ComputedEffectTiming(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace AnimationEffect_Binding {

  typedef mozilla::dom::AnimationEffect NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::AnimationEffect,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::AnimationEffect,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace AnimationEffect_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_AnimationEffectBinding_h
