/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef DOM_MEDIA_PLATFORMS_STREAMCAMERA_STREAMCAMERAENCODERMODULE_H_
#define DOM_MEDIA_PLATFORMS_STREAMCAMERA_STREAMCAMERAENCODERMODULE_H_

#include <streamcamera-codec.h>

#include "PlatformEncoderModule.h"

namespace mozilla {

class StreamCameraEncoderModule final : public PlatformEncoderModule {
 public:
  bool SupportsMimeType(const nsACString& aMimeType) const override;

  already_AddRefed<MediaDataEncoder> CreateVideoEncoder(
      const CreateEncoderParams& aParams) const override;

  static void Init();

 private:
  static bool sInitialized;
  static Aurora::StreamCamera::CodecManager* sCodecManager;
};

} // namespace mozilla

#endif
