/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef USBAUDIODEVICES_H
#define USBAUDIODEVICES_H

#include "systemsettingsglobal.h"

#include <QAbstractListModel>

class UsbAudioDevicesPrivate;

class SYSTEMSETTINGS_EXPORT UsbAudioDevices: public QAbstractListModel
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(UsbAudioDevices)

public:
    enum RoleNames {
        DeviceName = Qt::UserRole,
        AvailableTypes,
        CurrentType
    };
    Q_ENUM(RoleNames)

    enum DeviceType {
        Headset = 0,
        Headphone,
        Microphone,
        Soundbar
    };
    Q_ENUM(DeviceType)

    explicit UsbAudioDevices(QObject *parent = nullptr);

    int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    QVariant data(const QModelIndex &index, int role) const override;
    bool setData(const QModelIndex &index, const QVariant &value, int role) override;

protected:
    QHash<int, QByteArray> roleNames() const override;

private:
    UsbAudioDevicesPrivate *const d_ptr;
    friend class UsbAudioDevicesPrivate;
};

#endif /* USBAUDIODEVICES_H */
