/*
 * SPDX-FileCopyrightText: 2016 Jolla Ltd
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef PARTITIONMANAGER_H
#define PARTITIONMANAGER_H

#include <QObject>
#include <QVariant>

#include <partition.h>

class PartitionManagerPrivate;

class SYSTEMSETTINGS_EXPORT PartitionManager : public QObject
{
    Q_OBJECT
public:
    explicit PartitionManager(QObject *parent = 0);
    ~PartitionManager();

    Partition root() const;
    QVector<Partition> partitions(Partition::StorageTypes types = Partition::Any | Partition::ExcludeParents) const;
    QVector<Partition> externalStorages() const;

    void refresh();

    void mount(const Partition &partition);
    void unmount(const Partition &partition, const QVariantMap &options = QVariantMap());

signals:
    void partitionChanged(const Partition &partition);
    void partitionAdded(const Partition &partition);
    void storageAdded(const Partition &partition);
    void storageRemoved(const Partition &partition);
    void partitionRemoved(const Partition &partition);
    void externalStoragesPopulated();

private:
    QExplicitlySharedDataPointer<PartitionManagerPrivate> d;
};

#endif
