/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef EXTERNALSTORAGEPARTITIONMODEL_H
#define EXTERNALSTORAGEPARTITIONMODEL_H

#include "partitionmodel.h"

class SYSTEMSETTINGS_EXPORT ExternalStoragePartitionModel : public PartitionModel
{
    Q_OBJECT
    Q_PROPERTY(Partition storagePartition READ storagePartition WRITE setStoragePartition NOTIFY storagePartitionChanged)

public:
    explicit ExternalStoragePartitionModel(QObject *parent = nullptr);
    ~ExternalStoragePartitionModel() override;

    const Partition &storagePartition() const;
    void setStoragePartition(const Partition &partition);

signals:
    void storagePartitionChanged();

private:
    QVector<Partition> getUpdatedPartitions() override;

    Partition m_storagePartition;
};

#endif // EXTERNALSTORAGEPARTITIONMODEL_H
