/*****************************************************************************************
**
** SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
******************************************************************************************/

#ifndef ADMINISTRATION_H
#define ADMINISTRATION_H

#include <QObject>

#include <systemsettingsglobal.h>
#include <nemo-dbus/interface.h>

class SYSTEMSETTINGS_EXPORT Administration : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool terminalEnabled READ terminalEnabled WRITE setTerminalEnabled NOTIFY terminalEnabledChanged)

public:
    explicit Administration(QObject *parent = nullptr);

    bool terminalEnabled() const;
    void setTerminalEnabled(bool enabled);

public slots:
    void onTerminalEnabledChanged(bool newState);

signals:
    void terminalEnabledChanged(bool enabled);

private:
    void loadTerminalEnabled();

    NemoDBus::Interface m_developerModeDaemon;

    bool m_terminalEnabled;
};

#endif
