/*
 * SPDX-FileCopyrightText: 2021-2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#ifndef __STREAMCAMERAVIDEOOUTPUT__
#define __STREAMCAMERAVIDEOOUTPUT__

/**
 * \file videooutput_qt5.h
 * A glue to Qt5/QML VideoOutput.
 */

#include <streamcamera.h>

#include <qobject.h>
#include <qvideoframe.h>
#include <qabstractvideosurface.h>

namespace Aurora {
namespace StreamCamera {

class VideoOutputQt5Private;

class Q_DECL_EXPORT VideoOutputQt5 : public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool mirrored READ mirrored WRITE setMirrored NOTIFY mirroredChanged)
    Q_PROPERTY(QRect viewport READ viewport WRITE setViewport NOTIFY viewportChanged)
    Q_PROPERTY(QAbstractVideoSurface *videoSurface READ videoSurface WRITE setVideoSurface)

public:
    VideoOutputQt5(QObject *parent = nullptr);
    virtual ~VideoOutputQt5();

    bool mirrored() const;
    void setMirrored(bool mirror);

    QRect viewport() const;
    void setViewport(QRect viewport);

    QAbstractVideoSurface *videoSurface() const;
    void setVideoSurface(QAbstractVideoSurface *);

    void onGraphicBuffer(std::shared_ptr<Aurora::StreamCamera::GraphicBuffer> buffer);
    void onVideoFrame(const Aurora::StreamCamera::YCbCrFrame* frame);

    void stop();

Q_SIGNALS:
    void mirroredChanged(bool mirror);
    void viewportChanged(QRect viewport);

private:
    VideoOutputQt5Private *d_ptr;
    Q_DISABLE_COPY(VideoOutputQt5)
    Q_DECLARE_PRIVATE(VideoOutputQt5)
    Q_PRIVATE_SLOT(d_func(), void _q_stop())
    Q_PRIVATE_SLOT(d_func(), void _q_renderVideoFrame(QVideoFrame))
    Q_PRIVATE_SLOT(d_func(), void _q_setVideoSurface())
};

} // namespace StreamCamera
} // namespace Aurora

#endif /* __STREAMCAMERAVIDEOOUTPUT__ */
/* vim: set ts=4 et sw=4 tw=80: */
