/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <QObject>
#include <qmediaenumdebug.h>

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCSource;
class QVCSinkPrivate;

class Q_VIDEOCHAT_EXPORT QVCSink
{
public:
    enum Error
    {
        NoError,
        UnsupportedFormatError,
        IncorrectFormatError,
        StoppedError,
        ResourceError,
        HardwareError
    };

    virtual ~QVCSink();
    virtual bool link(QVCSource *source);
    virtual bool unlink(QVCSource *source);
    virtual void unlink();

    Error error() const;
    virtual bool isActive() const;

protected:
    explicit QVCSink();
    explicit QVCSink(QVCSinkPrivate &other);
    void setError(QVCSink::Error error);
    void setActive(bool active);

private:
    QVCSinkPrivate *d_ptr;
};

QT_END_NAMESPACE

Q_DECLARE_METATYPE(QVCSink::Error)

#define QVCSink_iid "ru.auroraos.videochat.sink/1.0"
Q_DECLARE_INTERFACE(QVCSink, QVCSink_iid);
