/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <qmediacontrol.h>

#include "qvcsource.h"

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class Q_VIDEOCHAT_EXPORT QVCEncodedVideoSourceControl
    : public QMediaControl
    , public QVCSource
{
    Q_OBJECT
    Q_INTERFACES(QVCSource)

public:
    ~QVCEncodedVideoSourceControl() = default;

protected:
    QVCEncodedVideoSourceControl(QObject *parent = nullptr) : QMediaControl(parent) { }
};

QT_END_NAMESPACE

#define QVCEncodedVideoSourceControl_iid "ru.auroraos.videochat.encodedvideosourcecontrol/1.0"
Q_MEDIA_DECLARE_CONTROL(QVCEncodedVideoSourceControl, QVCEncodedVideoSourceControl_iid)
