/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <QObject>
#include <QVideoEncoderSettings>

#include "qvcencodedvideoframe.h"
#include "qvcsink.h"

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCEncodedVideoSinkPrivate;

class Q_VIDEOCHAT_EXPORT QVCEncodedVideoSink : public QVCSink
{
public:
    ~QVCEncodedVideoSink();
    virtual bool isFormatSupported(const QVideoEncoderSettings &settings) const = 0;
    virtual bool start(const QVideoEncoderSettings &settings);
    virtual bool encodedVideoFrame(const QVCEncodedVideoFrame &frame) = 0;
    virtual void drain();
    virtual void stop();

    QVideoEncoderSettings videoEncoderSettings() const;

protected:
    explicit QVCEncodedVideoSink();
    explicit QVCEncodedVideoSink(QVCEncodedVideoSinkPrivate &);

private:
    Q_DECLARE_PRIVATE(QVCEncodedVideoSink)
    QVCEncodedVideoSinkPrivate *d_ptr;
};

QT_END_NAMESPACE

#define QVCEncodedVideoSink_iid "ru.auroraos.videochat.encodedvideosink/1.0"
Q_DECLARE_INTERFACE(QVCEncodedVideoSink, QVCEncodedVideoSink_iid);
