/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <QByteArray>
#include <QSize>
#include <QDebug>
#include <QtCore/qmetatype.h>
#include <QtCore/qshareddata.h>

#include <qtmultimediadefs.h>

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCEncodedVideoFramePrivate;

class Q_VIDEOCHAT_EXPORT QVCEncodedVideoFrame
{
public:
    enum class Type {
        Invalid,
        Key,
        Intra
    };

    struct MetaData
    {
        Type type = QVCEncodedVideoFrame::Type::Invalid;
        quint64 timestampUs = 0;
    };

    QVCEncodedVideoFrame();
    QVCEncodedVideoFrame(QByteArray &data, const MetaData &meta);
    QVCEncodedVideoFrame(const char *data, size_t size, const MetaData &meta);
    QVCEncodedVideoFrame(const QVCEncodedVideoFrame &other);
    ~QVCEncodedVideoFrame();

    QVCEncodedVideoFrame &operator =(const QVCEncodedVideoFrame &other);
    bool operator==(const QVCEncodedVideoFrame &other) const;
    bool operator!=(const QVCEncodedVideoFrame &other) const;

    bool isValid() const;
    QSize dimensions() const;

    QByteArray data() const;
    MetaData meta() const;

    void setTimestamp(quint64 timestampUs);

private:
    QExplicitlySharedDataPointer<QVCEncodedVideoFramePrivate> d;
};

QT_END_NAMESPACE

#ifndef QT_NO_DEBUG_STREAM
Q_VIDEOCHAT_EXPORT QDebug operator<<(QDebug, const QT_PREPEND_NAMESPACE(QVCEncodedVideoFrame&));
Q_VIDEOCHAT_EXPORT QDebug operator<<(QDebug, QT_PREPEND_NAMESPACE(QVCEncodedVideoFrame::Type&));
Q_VIDEOCHAT_EXPORT QDebug operator<<(QDebug, QT_PREPEND_NAMESPACE(QVCEncodedVideoFrame::MetaData&));
#endif

Q_DECLARE_METATYPE(QT_PREPEND_NAMESPACE(QVCEncodedVideoFrame))
Q_DECLARE_METATYPE(QT_PREPEND_NAMESPACE(QVCEncodedVideoFrame::Type))
Q_DECLARE_METATYPE(QT_PREPEND_NAMESPACE(QVCEncodedVideoFrame::MetaData))
