/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <qvcencoder.h>
#include <qvideoframe.h>
#include <qmediacontrol.h>
#include <qvideosurfaceformat.h>

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class Q_VIDEOCHAT_EXPORT QVCEncodeControl : public QMediaControl
{
    Q_OBJECT

public:
    ~QVCEncodeControl() = default;

    virtual QStringList supportedCodecs(bool hardwareOnly) const = 0;
    virtual QList<QVideoFrame::PixelFormat> supportedPixelFormats() const = 0;

    virtual QVCEncoder::Status status() const = 0;

    virtual bool start(const QVideoSurfaceFormat &format) = 0;
    virtual void drain() = 0;
    virtual void flush() = 0;
    virtual void stop() = 0;

public slots:
    virtual bool encode(const QVideoFrame &frame) = 0;

Q_SIGNALS:
    void encodedVideoFrame(QVCEncodedVideoFrame);
    void statusChanged(QVCEncoder::Status);
    void error(QVCEncoder::Error error, const QString &errorDescription);
    void endOfStream();

protected:
    explicit QVCEncodeControl(QObject *parent = nullptr) : QMediaControl(parent) { }
};

QT_END_NAMESPACE

#define QVCEncodeControl_iid "ru.auroraos.videochat.encodecontrol/1.0"
Q_MEDIA_DECLARE_CONTROL(QVCEncodeControl, QVCEncodeControl_iid)
