/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <qobject.h>

#include <qvcdecoder.h>
#include <qvcencodedvideosink.h>

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCDecodingVideoSinkPrivate;

class Q_VIDEOCHAT_EXPORT QVCDecodingVideoSink
    : public QObject
    , public QVCEncodedVideoSink
{
    Q_OBJECT
    Q_INTERFACES(QVCSink)
    Q_INTERFACES(QVCEncodedVideoSink)

public:
    explicit QVCDecodingVideoSink(QVCDecoder *decoder);
    ~QVCDecodingVideoSink();

    bool isFormatSupported(const QVideoEncoderSettings &settings) const override;
    bool start(const QVideoEncoderSettings &settings) override;
    bool encodedVideoFrame(const QVCEncodedVideoFrame &frame) override;
    void drain() override;
    void stop() override;

private:
    Q_DISABLE_COPY(QVCDecodingVideoSink)
    Q_DECLARE_PRIVATE(QVCDecodingVideoSink)
    Q_PRIVATE_SLOT(d_func(), void _q_error(QVCDecoder::Error))
    Q_PRIVATE_SLOT(d_func(), void _q_statusChanged(QVCDecoder::Status))
    QVCDecodingVideoSinkPrivate *d_ptr;
};

QT_END_NAMESPACE
