/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <qmediacontrol.h>
#include <qmediaencodersettings.h>
#include <qvideosurfaceformat.h>

#include "qvcdecoder.h"
#include "qvcencodedvideoframe.h"

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class Q_VIDEOCHAT_EXPORT QVCDecodeControl : public QMediaControl
{
    Q_OBJECT

public:
    virtual ~QVCDecodeControl() = default;

    virtual QStringList supportedCodecs(bool hardwareOnly) const = 0;
    virtual bool isFormatSupported(const QVideoEncoderSettings &settings) const = 0;
    virtual bool start(const QVideoEncoderSettings &settings) = 0;
    virtual QVideoEncoderSettings codecSettings() const = 0;
    virtual QVideoSurfaceFormat outputFormat() const = 0;
    virtual bool decode(const QVCEncodedVideoFrame &frame) = 0;
    virtual void drain() = 0;
    virtual void flush() = 0;
    virtual void stop() = 0;

    virtual QVCDecoder::Status status() const = 0;

Q_SIGNALS:
    void statusChanged(QVCDecoder::Status);
    void error(QVCDecoder::Error, const QString &error);
    void outputFormatChanged(const QVideoSurfaceFormat &format);
    void endOfStream();

protected:
    explicit QVCDecodeControl(QObject *parent = nullptr) : QMediaControl(parent) { }
};

QT_END_NAMESPACE

#define QVCDecodeControl_iid "ru.auroraos.videochat.decodecontrol/1.0"
Q_MEDIA_DECLARE_CONTROL(QVCDecodeControl, QVCDecodeControl_iid)
