/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <QObject>
#include <QSharedPointer>

#include "qvcdecoder.h"
#include "qvcencoder.h"

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCCodecInfoPrivate;

class Q_VIDEOCHAT_EXPORT QVCCodecInfo
{
public:
    QVCCodecInfo(const QByteArray &codecId);
    QVCCodecInfo(const QVCCodecInfo &other);
    ~QVCCodecInfo();

    QVCCodecInfo& operator=(const QVCCodecInfo& other);
    bool operator==(const QVCCodecInfo &other) const;
    inline bool operator!=(const QVCCodecInfo &other) const;

    bool isNull() const;

    QByteArray codecId() const;
    QString codec() const;
    bool isEncoder() const;
    bool isHardwareAccelerated() const;
    int maxInstances() const;

    static QList<QVCCodecInfo> availableEncoders(const QString &codec, bool hwAccelerated = true);
    static QList<QVCCodecInfo> availableDecoders(const QString &codec, bool hwAccelerated = true);

private:
    explicit QVCCodecInfo();
    QSharedPointer<QVCCodecInfoPrivate> d;
};

QT_END_NAMESPACE
