/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
** Copyright (C) 2015 The Qt Company Ltd.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <QtCore/qsharedpointer.h>
#include <QtMultimedia/qcamera.h>

#include "qvccamera.h"

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCCameraInfoPrivate;

class Q_VIDEOCHAT_EXPORT QVCCameraInfo
{
public:
    explicit QVCCameraInfo(const QByteArray &name = QByteArray());
    explicit QVCCameraInfo(const QVCCamera &camera);
    QVCCameraInfo(const QVCCameraInfo& other);
    ~QVCCameraInfo();

    QVCCameraInfo& operator=(const QVCCameraInfo& other);
    bool operator==(const QVCCameraInfo &other) const;
    inline bool operator!=(const QVCCameraInfo &other) const;

    bool isNull() const;

    QString deviceName() const;
    QString description() const;
    QCamera::Position position() const;
    int orientation() const;

    static QVCCameraInfo defaultCamera();
    static QList<QVCCameraInfo> availableCameras(QCamera::Position position = QCamera::UnspecifiedPosition);

private:
    QSharedPointer<QVCCameraInfoPrivate> d;
};

bool QVCCameraInfo::operator!=(const QVCCameraInfo &other) const { return !operator==(other); }

#ifndef QT_NO_DEBUG_STREAM
Q_VIDEOCHAT_EXPORT QDebug operator<<(QDebug, const QVCCameraInfo&);
#endif

QT_END_NAMESPACE
