/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
** Copyright (C) 2015 The Qt Company Ltd.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

#pragma once

#include <QtCore/qstringlist.h>
#include <QtCore/qpair.h>
#include <QtCore/qsize.h>
#include <QtCore/qpoint.h>
#include <QtCore/qrect.h>
#include <QtCore/qshareddata.h>

#include <QtMultimedia/qmediaobject.h>
#include <QtMultimedia/qmediaenumdebug.h>
#include <QCameraFocus>

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCCamera;
class QVCCameraFocusPrivate;

class Q_VIDEOCHAT_EXPORT QVCCameraFocus : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QCameraFocus::FocusModes focusMode READ focusMode WRITE setFocusMode)
    Q_PROPERTY(QCameraFocus::FocusPointMode focusPointMode READ focusPointMode WRITE setFocusPointMode)
    Q_PROPERTY(QPointF customFocusPoint READ customFocusPoint WRITE setCustomFocusPoint)
    Q_PROPERTY(QCameraFocusZoneList focusZones READ focusZones NOTIFY focusZonesChanged)
    Q_PROPERTY(qreal opticalZoom READ opticalZoom NOTIFY opticalZoomChanged)
    Q_PROPERTY(qreal digitalZoom READ digitalZoom NOTIFY digitalZoomChanged)

public:
    bool isAvailable() const;

    QCameraFocus::FocusModes focusMode() const;
    void setFocusMode(QCameraFocus::FocusModes mode);
    bool isFocusModeSupported(QCameraFocus::FocusModes mode) const;

    QCameraFocus::FocusPointMode focusPointMode() const;
    void setFocusPointMode(QCameraFocus::FocusPointMode mode);
    bool isFocusPointModeSupported(QCameraFocus::FocusPointMode) const;
    QPointF customFocusPoint() const;
    void setCustomFocusPoint(const QPointF &point);

    QCameraFocusZoneList focusZones() const;

    qreal maximumOpticalZoom() const;
    qreal maximumDigitalZoom() const;
    qreal opticalZoom() const;
    qreal digitalZoom() const;

    void zoomTo(qreal opticalZoom, qreal digitalZoom);

Q_SIGNALS:
    void opticalZoomChanged(qreal);
    void digitalZoomChanged(qreal);

    void focusZonesChanged();

    void maximumOpticalZoomChanged(qreal);
    void maximumDigitalZoomChanged(qreal);

private:
    friend class QVCCamera;
    friend class QVCCameraPrivate;
    QVCCameraFocus(QVCCamera *camera);
    ~QVCCameraFocus();

    Q_DISABLE_COPY(QVCCameraFocus)
    Q_DECLARE_PRIVATE(QVCCameraFocus)
    QVCCameraFocusPrivate *d_ptr;
};

QT_END_NAMESPACE
