/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
** Copyright (C) 2015 The Qt Company Ltd.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the QtVideoChat API.
// This header file may change from version to version without notice, or
// even be removed.
//

#pragma once

#include <qmediabindableinterface.h>

#include <QtCore/qsharedpointer.h>
#include <QtCore/qpointer.h>

class QAbstractVideoSurface;
class QVideoRendererControl;

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVideoSurfaceOutput : public QObject, public QMediaBindableInterface
{
    Q_OBJECT
    Q_INTERFACES(QMediaBindableInterface)
public:
    QVideoSurfaceOutput(QObject*parent = 0);
    ~QVideoSurfaceOutput();

    QMediaObject *mediaObject() const;

    void setVideoSurface(QAbstractVideoSurface *surface);

protected:
    bool setMediaObject(QMediaObject *object);

private:
    QPointer<QAbstractVideoSurface> m_surface;
    QPointer<QVideoRendererControl> m_control;
    QPointer<QMediaService> m_service;
    QPointer<QMediaObject> m_object;
};

QT_END_NAMESPACE
