/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the QtVideoChat API.
// This header file may change from version to version without notice, or
// even be removed.
//

#pragma once

#include <private/qmediaserviceprovider_p.h>

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

struct Q_VIDEOCHAT_EXPORT QVCMediaServiceCodecInfoInterface
{
    virtual ~QVCMediaServiceCodecInfoInterface() {}
    virtual QString codecType(const QByteArray &device) const = 0;
    virtual bool codecIsEncoder(const QByteArray &device) const = 0;
    virtual bool codecIsHardwareAccelerated(const QByteArray &device) const = 0;
    virtual int codecMaxInstances(const QByteArray &device) const = 0;
};

QT_END_NAMESPACE

#define QVCMediaServiceCodecInfoInterface_iid \
    "ru.auroraos.videochat.mediaservicecodecinfo/1.0"
Q_DECLARE_INTERFACE(QVCMediaServiceCodecInfoInterface, QVCMediaServiceCodecInfoInterface_iid)

QT_BEGIN_NAMESPACE

class Q_VIDEOCHAT_EXPORT QVCMediaServiceProvider
    : public QMediaServiceProvider
    , public QVCMediaServiceCodecInfoInterface
{
    Q_OBJECT
    Q_INTERFACES(QVCMediaServiceCodecInfoInterface);

public:
    virtual QString codecType(const QByteArray &device) const = 0;
    virtual bool codecIsEncoder(const QByteArray &device) const = 0;
    virtual bool codecIsHardwareAccelerated(const QByteArray &device) const = 0;
    virtual int codecMaxInstances(const QByteArray &device) const = 0;
};

QT_END_NAMESPACE

#define QVC_MEDIASERVICE_VIDEOCHAT_CAMERA "ru.auroraos.videochat.camera"
#define QVC_MEDIASERVICE_VIDEOCHAT_ENCODER "ru.auroraos.videochat.encoder"
#define QVC_MEDIASERVICE_VIDEOCHAT_DECODER "ru.auroraos.videochat.decoder"
