/****************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
**
** This file is a part of the QtVideoChat module.
**
** $QT_BEGIN_LICENSE:LGPL21$
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** $QT_END_LICENSE$
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the QtVideoChat API.
// This header file may change from version to version without notice, or
// even be removed.
//

#pragma once

#include <qvideosurfaceformat.h>
#include <private/qmediaobject_p.h>
#include <private/qvideosurfaceoutput_p.h>

#include <qvcglobal.h>

QT_BEGIN_NAMESPACE

class QVCEncodedVideoSourceControl;
class QVCSource;
class QVCDecodingVideoSink;
class QVCDecodeControl;

class QVCDecoderPrivate : public QMediaObjectPrivate
{
    Q_DECLARE_NON_CONST_PUBLIC(QVCDecoder)
public:
    QVCDecoderPrivate()
        : QMediaObjectPrivate()
        , mediaObject(nullptr)
        , videoOutput(nullptr)
        , decodeControl(nullptr)
        , sourceControl(nullptr)
        , sourceInterface(nullptr)
        , videoSink(nullptr)
        , error(QVCDecoder::NoError)
    {
    }
    ~QVCDecoderPrivate();

    void init();

    void _q_error(QVCDecoder::Error, const QString &errorString);
    void _q_outputFormatChanged(QVideoSurfaceFormat format);

    bool linkMediaObject(QMediaObject *object);
    bool linkSource(QVCSource *);
    void unlink();

    QMediaObject *mediaObject;

    QVideoSurfaceFormat outputFormat;
    QVideoSurfaceOutput surfaceVideoOutput;
    QObject *videoOutput;

    QVCDecodeControl *decodeControl;
    QVCEncodedVideoSourceControl *sourceControl;
    QVCSource *sourceInterface;
    QVCDecodingVideoSink *videoSink;

    QVCDecoder::Error error;
    QString errorString;
};

QT_END_NAMESPACE
