/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MARKET_LIB_EVENT_SUBSCRIPTION_HPP
#define MARKET_LIB_EVENT_SUBSCRIPTION_HPP

#include "globals.hpp"

#include <memory>

namespace Market {

class EventSubscriptionPrivate;

/**
 * @brief Class for managing a daemon event subscription.
 * @class EventSubscription event-subscription.hpp <market/event-subscription.hpp>
 *
 * @note This class automatically unsubscribes the market daemon client from
 *       event bound to this event subsription when the destructor is called
 *       for memory safety purposes. This class can be copied.
 */
class MARKET_LIB_EXPORT_SYMBOL EventSubscription
{
public:
    EventSubscription();
    EventSubscription(uint64_t id); /* NOLINT(google-explicit-constructor) */

    /**
     * @brief Get a unique event subscription ID.
     *
     * @return Unique event subscription ID.
     */
    uint64_t GetID() const;

private:
    std::shared_ptr<EventSubscriptionPrivate> m_pimpl;
};

} /* namespace Market */

#endif /* MARKET_LIB_EVENT_SUBSCRIPTION_HPP */
