/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>
#include <QImage>

namespace Aurora {
namespace WebView {
/**
 * @class Favicon
 * @brief Represents favicon of the website
 */
class Favicon
{
    Q_GADGET

    /// Favicon in PNG format represented as Base64 data
    Q_PROPERTY(QString base64PNGData READ base64PNGData)
    /// Favicon QImage
    Q_PROPERTY(QImage image READ image)
    /// Favicon size
    Q_PROPERTY(QSize size READ size)
public:
    /**
     * @brief Constructs an empty Favicon object
     */
    Favicon();
    /**
     * @brief Constructs a new Favicon object from QByteArray data
     *
     * @param favicon favicon data represented as QByteArray
     * @param faviconSize favicon size
     */
    Favicon(QByteArray favicon, QSize faviconSize);
    ~Favicon();

    QString base64PNGData() const;
    QImage image() const;
    QSize size() const;

private:
    QByteArray m_favicon;
    QSize m_size;
    mutable QString m_base64PNGData;
    mutable QImage m_image;
};

} // namespace WebView
} // namespace Aurora

Q_DECLARE_METATYPE(Aurora::WebView::Favicon)
