/*
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "browserextension.h"

#include <QObject>

namespace Aurora {
namespace WebView {

/**
 * @class IPasswordManagerExtension
 * @brief supports credentials save and autofill for websites
 *
 */
class IPasswordManagerExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IPasswordManagerExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}
    ~IPasswordManagerExtension() override = default;

    /**
     * @brief passes a credentials suggestion for the previous askForValuesToFill event
     *
     * @param username optional value for login field
     * @param password optional value for password field
     */
    virtual void passSuggestion(QString username, QString password) = 0;

signals:
    /**
     * @brief the signal is emitted when webview heuristics has detected successful login
     *
     * @param displayName short name for website identification
     * @param url login page address
     * @param username login value
     * @param password password value
     */
    void loginSuccessful(QString displayName, QString url, QString username, QString password);
    /**
     * @brief the signal is emitted when login form gets input focus
     *
     * @param url login page address
     */
    void askForValuesToFill(QString url);
};

} // namespace WebView
} // namespace Aurora
