/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "idialoghandler.h"

#include <QObject>

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

/**
 * @class DialogHandler
 * @brief use this singleton to handle file/folder picking dialogs
 * 
 * @link handlers.qml Usage Example @endlink
 */
class DialogHandler : public QObject, public IDialogHandler
{
    Q_OBJECT
public:
    /// @brief creates (if doesn't exist) and returns an instance of DialogHandler
    /// @return DialogHandler instance
    static QSharedPointer<DialogHandler> GetInstance(
        QQmlEngine *qmlEngine = nullptr, QJSEngine *jsEngine = nullptr);

    void requestFileDialog(const DialogRequest &dialogRequest) override;
signals:
    /// emitted when a user is requested to pick a single file
    void fileDialogRequested(DialogRequest dialogRequest);
    /// emitted when a user is requested to pick multiple files
    void multiFileDialogRequested(DialogRequest dialogRequest);
    /// emitted when a user is requested to pick a folder
    void folderDialogRequested(DialogRequest dialogRequest);

private:
    DialogHandler();
};

} // namespace WebView
} // namespace Aurora
