/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MARKET_LIB_EVENT_TYPE_HPP
#define MARKET_LIB_EVENT_TYPE_HPP

namespace Market {

/**
 * @brief Types of events a client can subscribe to.
 * @enum EventType
 */
enum EventType {
    /** New package installed */
    PackageInstalled,
    /** The existing package has been updated */
    PackageUpgraded,
    /** The existing package has been removed */
    PackageRemoved,
    /** The status of the created operation has changed */
    OperationStatusChanged,
};

} /* namespace Market */

#endif /* MARKET_LIB_EVENT_TYPE_HPP */
