/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef COMMON_OPERATION_TYPE_HPP
#define COMMON_OPERATION_TYPE_HPP

#ifdef __cplusplus
#define OPERATION_TYPE_ENUM_ENTRY(CPP, C) CPP
#else
#define OPERATION_TYPE_ENUM_ENTRY(CPP, C) OPERATION_TYPE_##C
#endif

#ifdef __cplusplus
/**
 * @brief General data types and enums
 * @namespace Common
 */
namespace Common {
#endif

/**
 * @brief Types of operations supported by the market daemon.
 * @enum OperationType
 */
enum OperationType {
    /** Package installation */
    OPERATION_TYPE_ENUM_ENTRY(Install, INSTALL) = 0,
    /** Package upgrade */
    OPERATION_TYPE_ENUM_ENTRY(Upgrade, UPGRADE),
    /** Package removal */
    OPERATION_TYPE_ENUM_ENTRY(Remove, REMOVE),
};

#ifndef __cplusplus
typedef enum OperationType OperationType;
#endif

#ifdef __cplusplus
} /* namespace Common */
#endif

#endif /* COMMON_OPERATION_TYPE_HPP */
