/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_TRUSTEDSOURCES_SERIALISATION_IMPL_P_H
#define SAILFISH_MDM_TRUSTEDSOURCES_SERIALISATION_IMPL_P_H

#include "mdm-trustedsources-types.h"

#include <QDBusArgument>

#ifndef SAILFISH_MDM_PROXY_BUILD
/**
 * Add typedef, because for some reason if we do
 * Q_DECLARE_METATYPE(Sailfish::Mdm::TrustedSource)
 * instead of Q_DECLARE_METATYPE(TrustedSource) we
 * lose the signals from the mdm-proxy in the mdm
 * library.
 */
typedef Sailfish::Mdm::TrustedSource TrustedSource;
#endif

Q_DECLARE_METATYPE(TrustedSource);

inline QDBusArgument &operator<<(QDBusArgument &argument, const TrustedSource &source)
{
    argument.beginStructure();
    argument << source.keyID;
    argument << source.subject;
    argument << source.details;
    argument.endStructure();
    return argument;
}

inline const QDBusArgument &operator>>(const QDBusArgument &argument, TrustedSource &source)
{
    argument.beginStructure();
    argument >> source.keyID;
    argument >> source.subject;
    argument >> source.details;
    argument.endStructure();
    return argument;
}

#endif // SAILFISH_MDM_TRUSTEDSOURCES_SERIALISATION_IMPL_P_H
