/*
 * Copyright (c) 2022 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SSU_P_H
#define SAILFISH_MDM_SSU_P_H

#include "mdm-ssu.h"

#include <QDBusInterface>
#include <ssuproxy.h>

namespace Sailfish {
namespace Mdm {

class SsuPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(SsuPrivate)
    Q_DECLARE_PUBLIC(Ssu)
public:
    explicit SsuPrivate(Ssu *q);

    Ssu *q_ptr;
    QScopedPointer<::SsuProxy> ssu;
    QDBusInterface proxy;
};

}
}

#endif // SAILFISH_MDM_SSU_P_H
