/*
 * SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

#include <memory>

#include "ipermissionrequest.h"

namespace Aurora {
namespace WebView {

class MediaAccessRequestInternal;

/**
 * @class MediaAccessRequest
 * @brief represents media access requests, e.g.,
 *        but not limited to, camera or microphone.
 */
class MediaAccessRequest : public IPermissionRequest
{
    Q_GADGET

    /// origin requesting the permission
    Q_PROPERTY(QString requestingOrigin READ requestingOrigin)
    /// list of requested permissions
    Q_PROPERTY(QVariantList requestedPermissions READ requestedPermissionsQML)
    /// true if this object is valid
    Q_PROPERTY(bool isValid READ isValid)
public:
    MediaAccessRequest();
    MediaAccessRequest(const MediaAccessRequest &other) = default;
    ~MediaAccessRequest() = default;

    Q_INVOKABLE void accept() override;
    Q_INVOKABLE void deny() override;

    bool isValid() const override;
    QString requestingOrigin() const override;
    QList<quint32> requestedPermissions() const override;
    QVariantList requestedPermissionsQML() const override;

private:
    MediaAccessRequest(std::shared_ptr<MediaAccessRequestInternal> mediaAccessRequestInternal);

    std::shared_ptr<MediaAccessRequestInternal> m_mediaAccessRequestInternal;

    friend class MediaAccessRequestInternal;
};

} // namespace WebView
} // namespace Aurora

Q_DECLARE_METATYPE(Aurora::WebView::MediaAccessRequest)
