/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "browserextension.h"
#include <cstdint>
#include <optional>
#include <QObject>

namespace Aurora {
namespace WebView {

struct TextureDescription
{
    std::int64_t textureId = 0;
    std::size_t width = 0;
    std::size_t height = 0;
    bool hasAlpha = false;
    bool textureFlipped = false;
};

enum class PopupOperation { KEEP, SHOW, HIDE };

class IRendering : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IRendering(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}
    virtual ~IRendering() = default;

    virtual void setFrameRate(const int frameRate) = 0;

    virtual float deviceScaleFactor() const = 0;
    virtual void setDeviceScaleFactor(float deviceScaleFactor) = 0;

    // relates to the quickitem size, shouldn't be scaled
    virtual QRect itemRect() const = 0;
    virtual void updateItemRect(const QRectF rect) = 0;
    // relates to the quickitem's rendering area, shouldn't be scaled
    virtual QRect renderRect() const = 0;
    virtual void updateRenderRect(QRectF rect) = 0;

    virtual bool renderPropsValid() = 0;

    virtual int colorDepth() const = 0;
    virtual void setColorDepth(const int depth) = 0;

    virtual QRectF popupRect() const = 0;

    virtual PopupOperation popupOperation() const = 0;
    virtual void setPopupOperation(const PopupOperation operation) = 0;

    virtual bool isAccelerated() const = 0;

    virtual std::optional<Aurora::WebView::TextureDescription> viewTextureDescriptionGL() = 0;
    virtual std::optional<Aurora::WebView::TextureDescription> popupTextureDescriptionGL() = 0;

    virtual std::optional<QImage> viewTextureSW() = 0;
    virtual std::optional<QImage> popupTextureSW() = 0;

signals:
    void viewTextureReady();
    void scrollOffsetChanged(double x, double y);
};

} // namespace WebView
} // namespace Aurora