/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "browserextension.h"
#include "contextmenuparams.h"
#include <QObject>

namespace Aurora {
namespace WebView {

class IContextMenuExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IContextMenuExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}

    virtual int x() const = 0;
    virtual int y() const = 0;

    virtual ContextMenuParams params() const = 0;

    virtual void execute(int commandId) = 0;
    virtual void cancel() = 0;
signals:
    void showMenuRequested();
    void dismissMenuRequested();
    void executeCustomCommandRequested(int commandId);
};

} // namespace WebView
} // namespace Aurora
