/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "browserextension.h"
#include "certificates/certificate.h"
#include "enums/types.h"

#include <QObject>

namespace Aurora {
namespace WebView {

class IConnectionInfoExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IConnectionInfoExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}
    virtual ~IConnectionInfoExtension() = default;

    virtual Connection::SecurityType securityStatus() const = 0;
    virtual Certificate certificate() const = 0;
    virtual QList<Certificate> certificateChain() const = 0;
signals:
    /**
     * @brief emitted when connection info is ready
     */
    void connectionInfoReady();
    /**
     * @brief emitted when connection security status is changed
     */
    void securityStatusChanged();
};

} // namespace WebView
} // namespace Aurora
