/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "cookie.h"

namespace Aurora {
namespace WebView {

class ICookieManager
{
public:
    virtual bool retrieveAllCookies() = 0;
    virtual bool retrieveUrlCookies(const QString &url, bool includeHttpOnly) = 0;
    virtual bool deleteCookies(const QString &url, const QString &cookieName) = 0;

    virtual void notifyAllCookiesAvailable(QList<Cookie> cookies) = 0;
    virtual void notifyUrlCookiesAvailable(QList<Cookie> cookies) = 0;
    virtual void notifyCookiesDeleted(int count) = 0;
};

} // namespace WebView
} // namespace Aurora
