/****************************************************************************
**
** SPDX-FileCopyrightText: 2020-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

#ifndef PUSH_CLIENT_H
#define PUSH_CLIENT_H

#include <QObject>

#include "push_types.h"

namespace Aurora {
namespace PushNotifications {

class ClientPrivate;
class Client final : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString applicationId READ applicationId CONSTANT)

public:
    Client(QObject *parent = nullptr);
    virtual ~Client();

    // Requests for push notifications server
    void registrate();

    // Check if push system can process application requests
    bool isPushSystemReady();

    // ApplicationID getter/setter
    QString applicationId() const;
    void setApplicationId(const QString &applicationId);

    // Get last error
    int error();
    QString errorMessage();

signals:
    // Push daemon info
    void pushSystemReadinessChanged(bool isReady);

    // Data from push notifcations server
    void registrationError();
    void registrationId(const QString &registrationId);
    void notifications(const Aurora::PushNotifications::PushList &pushList);

    // No new notifications in the set period of time
    void clientInactive();

private:
    Client(const Client &other) = delete;
    Client(Client &&other) = delete;

    ClientPrivate *d_ptr;
    Q_DECLARE_PRIVATE(Client)
};

} // namespace PushNotifications
} // namespace Aurora

#endif
