#ifndef AURORA_H
#define AURORA_H

#include "AudioDeviceModulePulse.h"

#include "absl/strings/match.h"

#include <string>
#include <vector>

namespace webrtc {
namespace aurora {

// H264 is prefered because it is hardware accelerated
// in StreamCamera

static inline std::vector<std::string> PreferedVideoCodecs() {
    return { "H264" };
}

static inline bool IsPreferedVideoCodec(const std::string& codec) {
    const auto prefered_codec_list = PreferedVideoCodecs();
    for ( const auto& prefered_codec : prefered_codec_list) {
        if (absl::EqualsIgnoreCase(codec, prefered_codec))
            return true;
    }
    return false;
}

} // namespace aurora
} // namespace webrtc

#endif // AURORA_H
