/****************************************************************************
**
** Copyright (C) 2020 Open Mobile Platform LLC
** Contact: https://community.omprussia.ru/
**
** This file is part of the pns.
**
****************************************************************************/

#ifndef PUSH_TYPES_H
#define PUSH_TYPES_H

#include <QDBusArgument>

namespace Aurora {
namespace PushNotifications {

struct Push
{
    QString data;
    QString title;
    QString message;
    QString action;
    QString image;
    QString sound;
    quint32 categoryId = 0;

    bool operator==(const Push &other) const;
    bool operator!=(const Push &other) const;
};

struct ExtendedPush
{
    QString pushId;
    Push push;
};

typedef QList<Push> PushList;

void registerTypes();

QDBusArgument &operator<<(QDBusArgument &argument, const Push &push);
const QDBusArgument &operator>>(const QDBusArgument &argument, Push &push);

} // PushNotificaitions namespace
} // Aurora namespace

Q_DECLARE_METATYPE(Aurora::PushNotifications::Push)
Q_DECLARE_METATYPE(Aurora::PushNotifications::PushList)

#endif
