#ifndef VIDEODECODERFACTORYH264STREAMCAMERA_H
#define VIDEODECODERFACTORYH264STREAMCAMERA_H

#include "VideoDecoderH264StreamCamera.h"

#include "api/video_codecs/sdp_video_format.h"
#include "api/video_codecs/video_decoder_factory.h"
#include "modules/video_coding/codecs/h264/include/h264.h"

#include <memory>

class VideoDecoderFactoryH264StreamCamera final : public webrtc::VideoDecoderFactory
{
public:
    VideoDecoderFactoryH264StreamCamera() {}

    ~VideoDecoderFactoryH264StreamCamera() override = default;

    std::vector<webrtc::SdpVideoFormat> GetSupportedFormats() const override
    {
        RTC_LOG_F(LS_INFO) << "";
        return {CreateH264Format(webrtc::H264Profile::kProfileBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "1"),
                CreateH264Format(webrtc::H264Profile::kProfileBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "0"),
                CreateH264Format(webrtc::H264Profile::kProfileConstrainedBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "1"),
                CreateH264Format(webrtc::H264Profile::kProfileConstrainedBaseline,
                                 webrtc::H264Level::kLevel3_1,
                                 "0"),
                CreateH264Format(webrtc::H264Profile::kProfileMain,
                                 webrtc::H264Level::kLevel3_1,
                                 "1"),
                CreateH264Format(webrtc::H264Profile::kProfileMain,
                                 webrtc::H264Level::kLevel3_1,
                                 "0")};
    }

    std::unique_ptr<webrtc::VideoDecoder> CreateVideoDecoder(
        const webrtc::SdpVideoFormat &format) override
    {
        return VideoDecoderH264StreamCamera::Create();
    }
};

#endif // VIDEODECODERFACTORYH264STREAMCAMERA_H
