/* This file is part of the Aurora OS SDK
*/

// Keep these in sync with org.merproject.emulator4qtcreator [[Begin
var emulatorVmName = "latest" === "ea"
    ? "AuroraOS-5.2.0.45EA"
    : "AuroraOS-5.2.0.45";
var emulatorVmSnapshotName = "5.2.0.45";
// End]]


function Component()
{
    console.log("Component constructor: " + component.name);
    if ("latest" === "5.2.0.45") {
        component.setValue("DisplayName", "AuroraOS-latest");
        component.setValue("Description",
                qsTranslate("installscript", "Emulates devices running %1 release %2")
                    .arg("Aurora OS")
                    .arg("5.2.0.45"));
    } else if ("latest" === "ea") {
        component.setValue("Description",
                qsTranslate("installscript", "Emulates devices running the latest %1 release " +
                        "published to Early Access users (%2)")
                    .arg("Aurora OS")
                    .arg("5.2.0.45"));
    } else if ("latest" === "latest") {
        component.setValue("Description",
                qsTranslate("installscript", "Emulates devices running the latest %1 release (%2)")
                    .arg("Aurora OS")
                    .arg("5.2.0.45"));
    } else {
        component.setValue("Description", "*** TRANSLATION MISSING !! ***");
    }

    component.setValue("Default", true)
}

// this is only called for the latest emulator
Component.prototype.isDefault = function()
{
    return installer.value("qemuPath");
}

Component.prototype.createOperationsForArchive = function(archive)
{
    const emulatorTargetDir = "@TargetDir@/emulator/";
    component.addOperation("Extract", archive, emulatorTargetDir);
    component.addOperation("SimpleMoveFile", emulatorTargetDir + "DefaultEmulator",
                                            emulatorTargetDir + emulatorVmName);
    
    component.registerPathForUninstallation(emulatorTargetDir, true);
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();
}
