@echo off
SetLocal EnableDelayedExpansion

set args="%*"
set include_args=%args:-E capabilities=%

if "%~1" == "-version" (
    docker run -i --rm --cap-add=SYS_ADMIN --security-opt apparmor:unconfined @docker_image_tag@ cmake %*
    goto :EOF
)

if "%~1" == "--version" (
    docker run -i --rm --cap-add=SYS_ADMIN --security-opt apparmor:unconfined @docker_image_tag@ cmake %*
    goto :EOF
)

if NOT !args!==!include_args! (
    docker run -i --rm --cap-add=SYS_ADMIN --security-opt apparmor:unconfined @docker_image_tag@ cmake %*
    goto :EOF
)

set OPT_ARGS=%*
:GETOPTS
if /I "%~1" == "-S" set SRC_DIR=%2 & set OPT_ARGS=!OPT_ARGS:%1 =! & set OPT_ARGS=!OPT_ARGS:%2 =! & shift & shift & goto GETOPTS
if /I "%~1" == "-B" set BUILD_DIR=%2 & set OPT_ARGS=!OPT_ARGS:%1 =! & set OPT_ARGS=!OPT_ARGS:%2 =! & shift & shift & goto GETOPTS

set TEST=%OPT_ARGS: =%
if not "!TEST!" == "" (
    SET OPT_ARGS= --extra-options="%OPT_ARGS:"='%"
) else (
    SET OPT_ARGS=
)

SET BUILD_DIR=!BUILD_DIR:%WORKSPACE_DIR%=/workspace!

SET SRC_DIR=!SRC_DIR:%WORKSPACE_DIR%=/workspace!

if not "%VAR_SPECFILE%" == "" (
    SET VAR_SPECFILE=--specfile "%VAR_SPECFILE%"
    SET VAR_SPECFILE=!VAR_SPECFILE:%WORKSPACE_DIR%=/workspace!
) else (
    SET VAR_SPECFILE=
)

if not exist .env.list (
    type nul > ".env.list"
)

docker run -i --rm --env-file .env.list --cap-add=SYS_ADMIN --security-opt apparmor:unconfined -v %WORKSPACE_DIR%:/workspace -w %BUILD_DIR% @docker_image_tag@ apptool build --arm64 --srcdir=%SRC_DIR% --dstdir=%BUILD_DIR% %VAR_SPECFILE% --configure%OPT_ARGS%
@install_dir@\bin\Cmapper @install_dir_unix@/sdk/@release@/targets/aarch64-meego-linux-gnu %WORKSPACE_DIR%

if exist QtCreatorDeployment.txt (
    powershell -Command "(gc QtCreatorDeployment.txt) -replace '/workspace', '%WORKSPACE_DIR%' | Out-File QtCreatorDeployment.txt"
)
