/* This file is part of the Aurora SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Maintenance tool"));
    component.setValue("Description", component.value("DisplayName"));

    if (component.fromOnlineRepository) {
        component.addDownloadableArchive("update.7z");
        component.addDownloadableArchive("sdkmaintenance.7z");
    }

    installer.valueChanged.connect( this, Component.prototype.reactOnTargetDirChange );
    Component.prototype.reactOnTargetDirChange("TargetDir", installer.value("TargetDir"));
}

Component.prototype.reactOnTargetDirChange = function(key, value)
{
    if (key !== "TargetDir")
        return;

    var os = installer.value('os');
    var executableExtension = os === 'win' ? ".exe" : "";
    var maintenanceToolPath = (os === 'mac')
        ? "@TargetDir@/SDKMaintenanceTool.app/Contents/MacOS/SDKMaintenanceTool"
        : "@TargetDir@/SDKMaintenanceTool" + executableExtension;
    installer.setValue("MaintenanceToolPath", maintenanceToolPath);
}

Component.prototype.createOperations = function()
{
    installer.installationFinished.connect( this, Component.prototype.installationFinished );

    // Call the base createOperations
    component.createOperations();

    // Force name change on SDK update
    installer.setValue("ProductName", "Aurora SDK");
    installer.setValue("ApplicationName", "@ProductName@");
    installer.setValue("Name", "@ProductName@");
    installer.setValue("Title", "@ProductName@");
    installer.setValue("Version", "2.0.0");

    var os = installer.value('os');
    if (os === 'x11') {
        component.addOperation("InstallIcons", "@TargetDir@/share/maintenance-tool-icons", "@ConfigVariant@" );
        component.addOperation("CreateDesktopEntry",
                               "@ConfigVariant@-MaintenanceTool.desktop",
                               "Type=Application\n" +
                               "Exec=@TargetDir@/SDKMaintenanceTool -name @ConfigVariant@-MaintenanceTool\n" +
                               "Path=@TargetDir@\n" +
                               "Name=@ProductName@ - Maintenance Tool\n" +
                               "GenericName=Install or uninstall components of @ProductName@.\n" +
                               "Icon=@ConfigVariant@-MaintenanceTool\n" +
                               "Terminal=false\n" +
                               "StartupWMClass=@ConfigVariant@-MaintenanceTool\n" +
                               "Categories=Development;Qt;"
                               );
    } else if (os === 'win') {
        component.addOperation("CreateShortcut",
                               "@TargetDir@/SDKMaintenanceTool.exe",
                               "@StartMenuDir@/SDK Maintenance Tool.lnk"
                               );
    }
}

Component.prototype.installationFinished = function()
{
    if (installer.status == QInstaller.Success) {
        // needed to be able to update the Maintenancetool itself
        installer.setInstallerBaseBinary("@TargetDir@/.tempSdkMaintenanceTool");
        installer.setValue("DefaultResourceReplacement", "@TargetDir@/update.rcc"); 
        installer.setValue("WatermarkPixmap", ":/metadata/installer-config/watermark_png.png")
        installer.setValue("Logo",":/metadata/installer-config/logo_png.png")
    }
}
