// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This header defines macros to export component's symbols.
// See "platform/PlatformExport.h" for details.

#ifndef THIRD_PARTY_BLINK_RENDERER_EXTENSIONS_CHROMEOS_EXTENSIONS_CHROMEOS_EXPORT_H_
#define THIRD_PARTY_BLINK_RENDERER_EXTENSIONS_CHROMEOS_EXTENSIONS_CHROMEOS_EXPORT_H_

#include "build/build_config.h"

//
// BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION
//
#if !defined(BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION)
#define BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION 0
#endif

//
// EXTENSIONS_CHROMEOS_EXPORT
//
#if !defined(COMPONENT_BUILD)
#define EXTENSIONS_CHROMEOS_EXPORT  // No need of export
#else

#if defined(COMPILER_MSVC)
#if BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION
#define EXTENSIONS_CHROMEOS_EXPORT __declspec(dllexport)
#else
#define EXTENSIONS_CHROMEOS_EXPORT __declspec(dllimport)
#endif
#endif  // defined(COMPILER_MSVC)

#if defined(COMPILER_GCC)
#if BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION
#define EXTENSIONS_CHROMEOS_EXPORT __attribute__((visibility("default")))
#else
#define EXTENSIONS_CHROMEOS_EXPORT
#endif
#endif  // defined(COMPILER_GCC)

#endif  // !defined(COMPONENT_BUILD)

//
// EXTENSIONS_CHROMEOS_EXTERN_TEMPLATE_EXPORT
// EXTENSIONS_CHROMEOS_TEMPLATE_EXPORT
//
#if BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION

#if defined(COMPILER_MSVC)
#define EXTENSIONS_CHROMEOS_EXTERN_TEMPLATE_EXPORT
#define EXTENSIONS_CHROMEOS_TEMPLATE_EXPORT EXTENSIONS_CHROMEOS_EXPORT
#endif

#if defined(COMPILER_GCC)
#define EXTENSIONS_CHROMEOS_EXTERN_TEMPLATE_EXPORT EXTENSIONS_CHROMEOS_EXPORT
#define EXTENSIONS_CHROMEOS_TEMPLATE_EXPORT
#endif

#else  // BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION

#define EXTENSIONS_CHROMEOS_EXTERN_TEMPLATE_EXPORT EXTENSIONS_CHROMEOS_EXPORT
#define EXTENSIONS_CHROMEOS_TEMPLATE_EXPORT

#endif  // BLINK_EXTENSIONS_CHROMEOS_IMPLEMENTATION

#endif  // THIRD_PARTY_BLINK_RENDERER_EXTENSIONS_CHROMEOS_EXTENSIONS_CHROMEOS_EXPORT_H_
