// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Claus

#ifndef IINAPPTAB_H
#define IINAPPTAB_H

#include "inapptaberror.h"

#include <QObject>
#include <QString>

class IInAppTab : public QObject
{
    Q_OBJECT
public:
    explicit IInAppTab(QObject *parent = nullptr)
        : QObject(parent)
    {}

    virtual ~IInAppTab() = default;

signals:
    /**
   * @brief Emitted when loading of the requested URL has started.
   * @param url The URL being loaded.
   */
    void loadStart(const QString &url);

    /**
   * @brief Emitted when loading of the requested URL has successfully
   * completed.
   * @param url The URL that finished loading.
   */
    void loadEnd(const QString &url);

    /**
   * @brief Emitted when loading fails with an error.
   * @param url The URL that failed to load.
   * @param error A description of the error.
   */
    void loadError(const QString &url, LoadError::LoadErrorType error);

    /**
   * @brief Emitted when the InAppTab process signals that the tab was closed.
   */
    void closed();

    /**
   * @brief Emitted when the InAppTab window is hidden by user.
   */
    void hideApp();
};

#endif // IINAPPTAB_H
