/*
 *
 *  ConnMan VPN daemon
 *
 *  Copyright (C) 2007-2012  Intel Corporation. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __VPN_DBUS_H
#define __VPN_DBUS_H

#include <dbus/dbus.h>

#ifdef __cplusplus
extern "C" {
#endif

#define VPN_SERVICE			"net.connman.vpn"
#define VPN_PATH			"/net/connman/vpn"
#define VPN_SHIM_SERVICE		"net.connman.vpn_shim"
#define VPN_SHIM_PATH			"/net/connman/vpn_shim"

#define VPN_ERROR_INTERFACE		VPN_SERVICE ".Error"

#define VPN_MANAGER_INTERFACE		VPN_SERVICE ".Manager"
#define VPN_MANAGER_PATH		"/"

#define VPN_LEGACY_PLUGIN_MANAGER_PATH      VPN_PATH "/legacy/pluginManager"
#define VPN_LEGACY_PLUGIN_MANAGER_INTERFACE VPN_SERVICE ".legacy.PluginManager"
#define VPN_LEGACY_SHIM_PATH                VPN_PATH "/legacy/Shim"
#define VPN_LEGACY_SHIM_INTERFACE           VPN_SERVICE ".legacy.Shim"
#define VPN_LEGACY_CALLBACK_PATH            VPN_PATH "/legacy/callback"
#define VPN_LEGACY_CALLBACK_INTERFACE       VPN_SERVICE ".legacy.Callback"
#define VPN_SHIM_LEGACY_DRIVER_PATH         VPN_SHIM_PATH "/legacy/driver"
#define VPN_SHIM_LEGACY_DRIVER_INTERFACE    VPN_SHIM_SERVICE ".legacy.Driver"
#define VPN_SHIM_LEGACY_CALLBACK_PATH       VPN_SHIM_PATH "/legacy/callback"
#define VPN_SHIM_LEGACY_CALLBACK_INTERFACE  VPN_SHIM_SERVICE ".legacy.Callback"

#define VPN_CONNECTION_INTERFACE	VPN_SERVICE ".Connection"
#define VPN_AGENT_INTERFACE		VPN_SERVICE ".Agent"
#define VPN_TASK_INTERFACE		VPN_SERVICE ".Task"

#define VPN_STORAGE_INTERFACE		VPN_SERVICE ".Storage"
#define VPN_STORAGE_PATH		"/"

#define VPN_PRIVILEGE_MODIFY		1
#define VPN_PRIVILEGE_SECRET		2

#define CONNECTION_ADDED		"ConnectionAdded"
#define CONNECTION_REMOVED		"ConnectionRemoved"
#define PROPERTY_CHANGED		"PropertyChanged"
#define GET_CONNECTIONS			"GetConnections"
#define VPN_CONNECT			"Connect"
#define VPN_CONNECT2			"Connect2"
#define VPN_DISCONNECT			"Disconnect"
#define VPN_REMOVE			"Remove"
#define VPN_STORAGE_CHANGE_USER		"ChangeUser"

#ifdef __cplusplus
}
#endif

#endif /* __VPN_DBUS_H */
