/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "ipdfprinthandler.h"
#include "pdfprintresult.h"

#include <QObject>

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

/**
 * @class PdfPrintHandler
 * @brief Emits "save as PDF" results of PdfPrintExtension
 *
 */
class PdfPrintHandler : public QObject, public IPdfPrintHandler
{
    Q_OBJECT
public:
    /// @brief creates (if doesn't exist) and returns an instance of PdfPrintHandler
    /// @return PdfPrintHandler instance
    static QSharedPointer<PdfPrintHandler> GetInstance(
        QQmlEngine *qmlEngine = nullptr, QJSEngine *jsEngine = nullptr);

    void pdfPrintResult(const PdfPrintResult &pdfPrintResult) override;

signals:
    /// emitted when a save as PDF result is available
    void pdfPrintResultAvailable(bool result, QString path);

private:
    PdfPrintHandler();
};

} // namespace WebView
} // namespace Aurora
