/*
 * SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QList>
#include <QString>
#include <QVariantList>

namespace Aurora {
namespace WebView {

/**
 * @class IPermissionRequest
 * @brief abstract class that contains fields common
 *        to PermissionRequest and MediaAccessRequest.
 */
class IPermissionRequest
{
public:
    IPermissionRequest() = default;
    IPermissionRequest(const IPermissionRequest &other) = default;
    virtual ~IPermissionRequest() = default;

    virtual void accept() = 0; ///< accept the request
    virtual void deny() = 0;   ///< reject the request

    virtual QString requestingOrigin() const = 0;
    virtual QList<quint32> requestedPermissions() const = 0;
    virtual QVariantList requestedPermissionsQML() const = 0;
    virtual bool isValid() const = 0;
};

} // namespace WebView
} // namespace Aurora
