/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "dialogrequest.h"

#include <memory>

namespace Aurora {
namespace WebView {

/**
 * @class IDialogHandler
 * @brief Interface for DialogHandler.
 * 
 * You can implement this interface to override default DialogHandler. However,
 * note that instantiating an external implementation disables default QML wrapper,
 * so you might also need to create it on your own.
 *
 * Browser engine starts using an external implementation as soon as it is created.
 * Please note that only the last created implementation is used. As soon as
 * a new implementation is instantiated, all previous implementations become invalid.
 */
class IDialogHandler
{
public:
    /**
     * @brief Construct a new IDialogHandler object
     */
    IDialogHandler();
    /**
     * @brief Destroy the IDownloadHandler object
     */
    virtual ~IDialogHandler() = default;

    /**
     * @brief called when a new file/folder dialog is requested
     * 
     * @param dialogRequest object that provides interaction mechanism with the request
     */
    virtual void requestFileDialog(const DialogRequest &dialogRequest) = 0;
};

} // namespace WebView
} // namespace Aurora
