/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>
#include <QObject>

#include "browserextension.h"

class QUrl;

namespace Aurora {
namespace WebView {

class ILoadRequestFilter
{
public:
    virtual ~ILoadRequestFilter() = default;
    virtual bool beforeUrlLoad(const QUrl &url, bool userGesture, bool isRedirect) = 0;
};

class ILoadRequestExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    ILoadRequestExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}
    virtual ~ILoadRequestExtension() = default;

    virtual void setLoadRequestFilter(std::shared_ptr<ILoadRequestFilter> filter) = 0;
    virtual std::shared_ptr<ILoadRequestFilter> loadRequestFilter() const = 0;

    virtual void setNativeSchemeHandling(bool enabled) = 0;
    virtual bool nativeSchemeHandling() const = 0;

signals:
    void nativeSchemeHandlingChanged();
};

} // namespace WebView
} // namespace Aurora
