/*
 * SPDX-FileCopyrightText: Copyright 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "ipopuphandler.h"

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

class IClient;

/**
 * @class PopupHandler
 * @brief Use this singleton to handle popup and new tab requests
 * 
 * This singleton notifies about new popup and tab requests
 */
class PopupHandler : public QObject, public IPopupHandler
{
    Q_OBJECT
public:
    /// @brief default destructor
    ~PopupHandler() = default;

    /// @brief creates (if doesn't exist) and returns an instance of PopupHandler
    /// @return PopupHandler instance
    static QSharedPointer<PopupHandler> GetInstance(
        QQmlEngine *qmlEngine = nullptr, QJSEngine *jsEngine = nullptr);

    void notifyTabRequested(const TabInfo &info) override;
    void notifyPopupRequested(const PopupInfo &info) override;

signals:
    /// emitted when a new tab is requested
    /// @param info contains tab request info (e.g., url to load)
    void tabRequested(TabInfo request);
    /// emitted when a new popup is requested
    /// @param request contains popup request info (e.g., url to load)
    void popupRequested(PopupInfo request);

private:
    explicit PopupHandler(IClient *client = nullptr);
};

} // namespace WebView
} // namespace Aurora
