/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "jsdialogs/alertdialogrequest.h"
#include "jsdialogs/beforeunloaddialogrequest.h"
#include "jsdialogs/confirmdialogrequest.h"
#include "jsdialogs/ijsdialoghandler.h"
#include "jsdialogs/promptdialogrequest.h"

#include <QObject>

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

/**
 * @class JSDialogHandler
 * @brief use this singleton to handle JS dialogs (e.g., alert, prompt)
 */
class JSDialogHandler : public QObject, public IJSDialogHandler
{
    Q_OBJECT
public:
    /// @brief creates (if doesn't exist) and returns an instance of JSDialogHandler
    /// @return JSDialogHandler instance
    static QSharedPointer<JSDialogHandler> GetInstance(
        QQmlEngine *qmlEngine = nullptr, QJSEngine *jsEngine = nullptr);

    void requestJSDialog(const JSDialogRequest &jsDialogRequest) override;
signals:
    /// emitted when a new "alert" dialog is requested
    void alertDialogRequested(AlertDialogRequest jsDialogRequest);
    /// emitted when a new "confirm" dialog is requested
    void confirmDialogRequested(ConfirmDialogRequest jsDialogRequest);
    /// emitted when a new "prompt" dialog is requested
    void promptDialogRequested(PromptDialogRequest jsDialogRequest);
    /// emitted when a user attempts to leave a page with unsaved changes
    void beforeUnloadDialogRequested(BeforeUnloadDialogRequest jsDialogRequest);

private:
    JSDialogHandler();
};

} // namespace WebView
} // namespace Aurora
