/*
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>
#include <QObject>

#include "browserextension.h"

class QUrl;

namespace Aurora {
namespace WebView {

const QString POPUP_IS_TO_BE_CREATED_PROPERTY = "popupIsToBeCreated";

class IPopupCallbacks
{
public:
    virtual ~IPopupCallbacks() = default;
    virtual bool beforePopup(const QUrl &url, const QString &frameName, bool userGesture) = 0;
    virtual void popupReady() = 0;
};

class IPopupExtension : public QObject, public Cef::BrowserExtension
{
    Q_OBJECT
public:
    IPopupExtension(Cef::Browser &browser)
        : Cef::BrowserExtension(browser)
    {}
    virtual ~IPopupExtension() = default;

    virtual void setPopupCallbacks(std::shared_ptr<IPopupCallbacks> filter) = 0;
    virtual std::shared_ptr<IPopupCallbacks> popupCallbacks() const = 0;

    virtual bool bindPopup() = 0;
};

} // namespace WebView
} // namespace Aurora
